# CLUTCH VS ESTIMATED INTERVAL
# SECTIONS 2.5 and 3.5

library(dplyr)
library(geepack)

#NRS
INTERVAL <- read.csv("Pied Flycatcher Phenology/Interval estimation/Interval/intervals_2013_16.csv")
nrs4 <- read.csv2("Pied Flycatcher Phenology/Interval estimation/Laying/data/NRS_rawdata.csv")
nrs4$northing10 <- nrs4$northing10/1000 # working at km scale

# get estimates of the population level interval 
nrsfinal <- left_join(nrs4, INTERVAL, c("year","northing10"))

# which variables we are working with
nrsf2 <- select(nrsfinal, c(year,quant.50,klutch, northing10))

# choosing northings below 600 km
nrsf <- nrsf2[is.na(nrsf2$quant.50)==FALSE&nrsf2$northing10<=600,]

# aggregating by 100 km blocks to be more robust
nrsf$northing100 <- floor(nrsf$northing10/100)
nrs_blocks <- aggregate(klutch~northing100+year, FUN=mean, data = nrsf)
nrs_blocks$group <- 1:nrow(nrs_blocks)
nrs_b <- left_join(nrsf,nrs_blocks, by = c("northing100","year"))

# final model
eff.gee.ar <- geeglm(klutch.x~quant.50,  data=nrs_b, id= group, family = poisson("identity"),
                   corstr = "independence")
summary(eff.gee.ar)


